set echo on
--autor: Radoslav Golian
--popis: Skript demonstruje modifikovatelne pohlady a ich pouzitie

-- nacitame inicializacne parametre
@params.sql

-- umoznime pouzitie inicializacnych parametrov
set define on

prompt Prihlasime sa ako pouzivatel &user_name

connect &user_name/&user_pass&db_name

prompt vytvorime tabulku transaction nad ktorou budeme demonstrovat vlastnosti modifikovatelnych pohladov
create table transaction(id number primary key,
                         client_id number,
                         from_account varchar2(10),
                         to_account varchar2(10),
                         amount number(8,2),
                         notes varchar2(256)) tablespace USERS;

pause Pre pokracovanie stlacte Enter

prompt Vlozime do tabulu niekolko zaznamov
insert into transaction(id, client_id, from_account, to_account, amount, notes)
values (1, 10, '5556667778', '9996663332', 5000, 'najomne za september');

insert into transaction(id, client_id, from_account, to_account, amount, notes)
values (2, 10, '5556667778', '9996663332', 5000, 'najomne za oktober');

insert into transaction(id, client_id, from_account, to_account, amount, notes)
values (3, 10, '5556667778', '9996663332', 10000, 'najomne za december');

insert into transaction(id, client_id, from_account, to_account, amount, notes)
values (4, 11, '0001112223', '0001112224', 10000, 'vypalne');

commit;

pause Pre pokracovanie stlacte Enter

prompt Pre vytvorime modifikovatelny pohlad, ktory umozni manipulovat len so zaznamami kde  client_id = 10

create view v_transaction as
select id, client_id, from_account, to_account, amount, notes
from transaction
where client_id = 10
with check option;

pause Pre pokracovanie stlacte Enter
prompt Pridelime opravnenia na INSERT a SELECT pouzivatelovi &user_name2
prompt Pridelime opravnenie UPDATE na stlpec notes pouzivatelovi &user_name2

grant insert on v_transaction to &user_name2;
grant update(notes) on v_transaction to &user_name2;
grant select on v_transaction to &user_name2;

pause Pre pokracovanie stlacte Enter

prompt Prihlasime sa ako pouzivatel &user_name
connect &user_name2/&user_pass2

-- zmenime format zobrazovania stlpca notes - sirka bude 30znakov
column notes format a30;

prompt Vykoname prikaz SELECT, budeme vidiet len zaznamy s client_id=10

select * 
from &user_name .v_transaction;

pause Pre pokracovanie stlacte Enter
prompt Vykoname prikaz

prompt Vykoname prikaz UPDATE stlpca notes
prompt Prikaz sa uspesne vykona

update &user_name .v_transaction
set notes='najomne za december a januar'
where id=3;

pause Pre pokracovanie stlacte Enter

prompt Vykoname prikaz UPDATE na stlpec amount
prompt Prikaz skonci chybou, pretoze nemame potrebne opravnenie

update &user_name .v_transaction
set notes='najomne za december a januar', amount=60000
where id=3;

pause Pre pokracovanie stlacte Enter

prompt Vykoname prikaz INSERT vlozime zaznam s client_id=10
prompt Prikaz sa podari
insert into &user_name .v_transaction(id, client_id, from_account, to_account, amount, notes)
values (5, 10, '5556667778', '9996663332', 5000, 'najomne za februar');

pause Pre pokracovanie stlacte Enter

prompt Vykoname prikaz prikaz INSERT, pricom ako pouzijeme pre client_id hodnotu 11
prompt Prikaz skonci chybou, pretoze pre vlozeny zaznam nie je splnena podmienka client_id=10
insert into &user_name .v_transaction(id, client_id, from_account, to_account, amount, notes)
values (6, 11, '5556667778', '9996663332', 5000, 'najomne za februar');

pause Pre pokracovanie stlacte Enter
prompt Zobrazime nase zaznamy v tabulke transaction
select * from &user_name.v_transaction;

pause Pre pokracovanie stlacte Enter
prompt Ukoncime spojenie
exit


